/*------------------------------------------------------------------------------*
 *	File Name: 	ocStatEx.h								 						*
 *	Purpose: Advanced Statistics Functions, mostly based on NAG lib routines   	*
 *  Creation:	11/11/2005, CPY and Max											*
 *  	Copyright Originlab Corp. 2005, 2006,									*
 *	Modification log	                                                        *
 *  Justin on 03/30/2007 MODIFY_FUNCTION_CATEGORY								*
 *------------------------------------------------------------------------------*/      

#ifndef _OCSTATEX_H
#define _OCSTATEX_H

#ifdef __AFX_H__
	#ifdef OCSTATEX_DLL
		#define OCSTATEX_API __declspec(dllexport)
	#else
		#define OCSTATEX_API __declspec(dllimport)
	#endif
	
	#include ".\..\..\MFC\ocMath\stats_types.h"

	#define string 			CString  //DSC 9/26/05 QA70-8113 TEST_DATAID_EXITS_AND_VALID


	#define TreeNode		OCXmlWrapperBase
	#define StringArray		CScriptMocaObject
	#define	IntArray		CScriptMocaObject
	extern "C" {
#else
	#define OCSTATEX_API
	#pragma dll(ocStatEx)	// Associate all functions below to ocStatEx.dll which must be in the Origin EXE folder
	#define	IntArray	vector<int>
#endif	//__AFX_H__


#define MTEST_STAT_SIZE			5	// numbers of statisitics for multivariate test
#define ANOVA_STAT_SIZE			5	// numbers of statisitics for ANOVA table
#define SPHERIC_STAT_SIZE		4	// numbers of statisitics for sphericity test
#define EPSILON_STAT_SIZE		3	// numbers of statisitics for Epsilon adjustment
#define ANOVA_UNADJUSTED		0	// Unadjusted method for the means comparison

#define WARNNING_CANNOT_CALC_MAUCHLY_TEST			2
#define WARNNING_CANNOT_CALC_MULTI_TEST				3
#define WARNNING_CANNOT_CALC_MAUCHLY_OR_MULTI_TEST	4
 

// Category last updated by Justin on 03/30/2007
/** >Statistics>Advanced
	Remarks:
	Parameters:
	Return:
*/
OCSTATEX_API int ocStatEx_rm_anova_one_way(const MeanCompMethod *nIntervalType,
							  const double *pData, uint nSizeData,
				  			  int nSizeSubject,
							  int nGroupSize,
							  double dAlpha, 
							  int ncntrl,
							  RMANOVADescStats* pDescStats, uint nSizeDescStat,
							  RMANOVAOneWay *RMANOVATable, 
							  MeanCompStats *pMeanCompStats, uint nSizeMeanComp,
							  MultiTestTable *RVMultiStats,
							  SphericityStats *RVSphericStats,
							  EpsilonStats *RVEpsilonStats);

// Category last updated by Justin on 03/30/2007
/** >Statistics>Advanced
	Remarks:
	Parameters:
	Return:
*/
OCSTATEX_API int ocStatEx_rm_anova_two_way_one_rv(const MeanCompMethod *nIntervalType,
								int iInteraction,
								const double *pData, uint nSizeData,
								const int *pNonRVData, uint nSizeNonRVData,
								int nSizeSubject,
								int nRVGroupSize,
								int nNonRVGroupSize,
								double dAlpha, 
								int ncntrl1,
								int ncntrl2,
								RMANOVADescStats* pRVDescStats, uint nSizeRVDescStat,
								RMANOVADescStats* pNonRVDescStats, uint nSizeNonRVDescStat,
								RMANOVADescStats* pInterDescStats, uint nSizeInterDescStat,
								RMANOVATwoWayOneRV *RMANOVATable, 
								MeanCompStats *pRVMeanCompStats, uint nSizeRVMeanComp,
								MeanCompStats *pNonRVMeanCompStats, uint nSizeNonRVMeanComp,
								MeanCompStats *pFixNonRVMeanCompStats, uint nSizeFixNonRVMeanComp,
								MeanCompStats *pFixRVMeanCompStats, uint nSizeFixRVMeanComp,
								MultiTestTable *RVMultiStats,
								MultiTestTable *InterMultiStats,
								SphericityStats *RVSphericStats,
								EpsilonStats *RVEpsilonStats);

// Category last updated by Justin on 03/30/2007
/** >Statistics>Advanced
	Remarks:
	Parameters:
	Return:
*/
OCSTATEX_API int ocStatEx_rm_anova_two_way_two_rv(const MeanCompMethod *nIntervalType,
								int iInteraction,
								const double *pData, uint nSizeData,
								int nSizeSubject,
								int nGroupSize,
								int nRV1Levels,
								int nRV2Levels,
								double dAlpha, 
								int ncntrl1,
								int ncntrl2,
								RMANOVADescStats* pRV1DescStats, uint nSizeRV1DescStat,
								RMANOVADescStats* pRV2DescStats, uint nSizeRV2DescStat,
								RMANOVADescStats* pInterDescStats, uint nSizeInterDescStat,
								RMANOVATwoWayTwoRV *RMANOVATable, 
								MeanCompStats *pRV1MeanCompStats, uint nSizeRV1MeanComp,
								MeanCompStats *pRV2MeanCompStats, uint nSizeRV2MeanComp,
								MeanCompStats *pFixRV2MeanCompStats, uint nSizeFixRV2MeanComp,
								MeanCompStats *pFixRV1MeanCompStats, uint nSizeFixRV1MeanComp,
								MultiTestTable *RV1MultiStats,
								MultiTestTable *RV2MultiStats,
								MultiTestTable *InterMultiStats,
								SphericityStats *RV1SphericStats,
								SphericityStats *RV2SphericStats,
								SphericityStats *InterSphericStats,
								EpsilonStats *RV1EpsilonStats,
								EpsilonStats *RV2EpsilonStats,
								EpsilonStats *InterEpsilonStats);

#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif //_OCSTATEX_H
